<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

require_once 'config.php';

try {
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (!$data) {
        throw new Exception('Data tidak valid');
    }
    
    $stmt = $pdo->prepare("INSERT INTO orders (nama_pemesan, qty_a, qty_b, qty_c, qty_d, qty_e, total_harga) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $result = $stmt->execute([
        $data['nama_pemesan'],
        $data['qty_a'],
        $data['qty_b'],
        $data['qty_c'],
        $data['qty_d'],
        $data['qty_e'],
        $data['total_harga']
    ]);
    
    if ($result) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Gagal menyimpan pesanan']);
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>